﻿// Output to the log file, writing to the text file
#include <CoreAPI.h>
//If you need the release build at full speed please change the Debug below to Release
//@config: Debug

// Logging is important part of debugging. First, you need to specify where the logging will be performed
// Generally, coat::logger may be use for the regular text-file output, not just for logging.
// In this case you may declare the coat::logger object within any function, output there and then call close()
coat::logger dbg("mylog.txt");
EXPORT
int main(){
	dbg << "Hello world!";
	// the vector just as example
	coat::vec3 v(1, 2, 3);
	// we start from the new line, so we cal newline(), the we pass all arguments one-by-one
	dbg.newline() << "Float output: " << 0.1234f << " Integer output: " << 123 << " \nVector: [ " << v << "]";
	// logging may be used for the profiling. Now we calculate time in microseconds spent for some operation
	dbg.startTimer();
	double s = 0;
	for(int i=0;i<1000000;i++) {
		s += i;
	}
	// the endTimer() writes the time passed since the last startTimer(), so you may estimate the execution time
	dbg.newline().endTimer() << "(microseconds)";
	// as soon as we call flush the text will be written to the file.
	// You may call the close(), it this case file wil be closed and all further attempts to pass data there
	// will overwrite all previous data.
	dbg.flush();
	// open() opens the default text editor to see your results
	dbg.open();
	// other was is showMessage() - it triggers the dialog in the 3DCoat
	dbg.showMessage();

	return 0;
}