// Iterate over the sculpt tree, show the basic stats - square, volume 
#include <CoreAPI.h>
//If you need the release build at full speed please change the Debug below to Release
//@config: Debug

/**
 * \brief this class represents the one line in the info box, the square and volume of one sculpt object
 */
class OneLine :public BaseClass {
public:
	OneLine() {
		Square = Volume = 0;
	}
	OneLine(coat::SceneElement el) {
		name = el.name();
		Square = el.Volume().getSquare();
		Volume = el.Volume().getVolume();
	}
	coat::str name;
	float Square;
	float Volume;

	SERIALIZE() {
		UI_LAYOUT("3");
		//"!identifier" means that it is readonly and it's name does not appear in UI
		READONLY REG_AUTO(name, "!name");
		READONLY REG_AUTO(Square, "!Square");
		READONLY REG_AUTO(Volume, "!Volume");
	}
};

// This is the class to represent the information about all volumes
class Stats:public BaseClass {
public:
	Stats() {		
	}
	void Calculate() {
		// get the sculpt root
		auto r = coat::Scene::sculptRoot();
		// iterate through all sculpt objects
		r.iterateSubtree(
			[&](coat::SceneElement el) -> bool {
				// adding the element to ClassArray to represent in UI
				if (el.isSculptObject())lines.Add(new OneLine(el));
				return false;
			});
	}
	// This is the list of volumes, ClassArray is the array of pointers to BaseClass-derived items
	// ClassArray<...> may be registered with REG_AUTO(...)
	ClassArray<OneLine> lines;	
	SERIALIZE() {
		// making the header, 3 columns
		UI_LAYOUT("3");
		// "*name" means it is left-aligned text
		TEXTMSG2("*Name");
		TEXTMSG2("*Square");
		TEXTMSG2("*Volume");

		// the lines with info, ClassArray<...> may be registered with REG_AUTO
		// and will appear in the UI
		REG_AUTO(lines);
	}
};

EXPORT
int main(){
	{
		Stats stats;
		// calculate the stats
		stats.Calculate();
		coat::dialog().ok().params(&stats).show();		
	}
	return 0;
}