// This example generates the surface figure that consists of tube
#include <CoreAPI.h>
//@config: Debug
class TubePrim:public BaseClass {
public:
	TubePrim() {
		Radius2 = 30;
		Radius1 = 30;
		Thickness = 8;
		Height = 200;
		Fillet = 0.0;
	}
	float Radius2;
	float Radius1;
	float Thickness;
	float Height;
	float Fillet;
	
	// this is class registration, look dialogs example
	SERIALIZE() {
		FSLIDER(Radius1, "%Radius1", 10, 100, 20, false);
		FSLIDER(Radius2, "%Radius2", 10, 100, 20, false);
		FSLIDER(Thickness, "%Thickness", 5, 40, 10, false);
		FSLIDER(Height, "%Height", 20, 200.0, 100, false);
		FSLIDER(Fillet, "%Fillet", 0.1, 10.0, 1, false);
	}
	void build() {
		auto voxId = coat::Scene::sculptRoot().childCount();
		auto current = coat::Scene::sculptRoot().addChild("Tube"+coat::str::ToString(voxId));
		auto volume = current.Volume();
		volume.toSurface();
		coat::tube tube;
		tube.height(Height)
			.radiusTop(Radius2)
			.radiusBottom(Radius1)
			.Obj<coat::tube>()
			.thickness(Thickness)
			.fillet(Fillet)
			.details(0.2)
			.add(volume);
	}
};


EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	TubePrim tubePrim;
	coat::dialog dlg;
	// load settings if exist
	tubePrim.ReadFromFile("data/Temp/tube.json");
	if(dlg.ok().cancel().params(&tubePrim).show() == 1) {// ok pressed, buttons start from 1
		// save settings
		tubePrim.WriteToFile("data/Temp/tube.json");
		// build the figure
		tubePrim.build();
	};
	return 0;
}