// Generate the surface figure that consists of spheres
#include <CoreAPI.h>
//@config: Debug
class SpheresPrim:public BaseClass {
public:
	SpheresPrim() {
		BaseRadius = 100;
		SubDivisions = 1;
		Rings = 12;
		Slices = 24;
		DivMode = coat::sphere::DivisionMode::DIV_TRIANGLE;
	}
	float BaseRadius;
	int SubDivisions;
	int Rings;
	int Slices; 	
	coat::sphere::DivisionMode DivMode;
	// this is class registration, look dialogs example
	SERIALIZE() {
		Enumerator* E = ENUM.Get("DIVMODE");
		if (E->GetAmount() == 0) {
			E->Add("triangle");
			E->Add("meridian");
			E->Add("cube");
		}
		REG_DROPLIST(DivMode,"DivMode","DIVMODE");
		FSLIDER(BaseRadius, "BaseRadius", 50, 200, 1, false);
		if (DivMode == coat::sphere::DivisionMode::DIV_MERIDIAN){
			SLIDER(Slices, "Slices", 8, 60);
			SLIDER(Rings, "Rings", 6, 60);
		
		} 
		else if (DivMode == coat::sphere::DivisionMode::DIV_CUBE) {
			SLIDER(SubDivisions, "SubDivisions", 2, 20);	
		} 
		else {
			SLIDER(SubDivisions,"SubDivisions", 1, 10);	
		}
	}
	void build() {
		auto voxId = coat::Scene::sculptRoot().childCount();
		auto current = coat::Scene::sculptRoot().addChild("Spheres"+coat::str::ToString(voxId));
		auto volume = current.Volume();
		volume.toSurface();
		coat::sphere sphere;
		sphere.radius(BaseRadius).sub_div_mode(DivMode).sub_division(SubDivisions).rings(Rings).slices(Slices).add(volume);
		sphere.radius(BaseRadius/2).translate(coat::vec3(0,0,1.5*BaseRadius)).add(volume);
		sphere.radius(BaseRadius/2).translate(coat::vec3(0,0,-1.5*BaseRadius)).add(volume);
	}
};


EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	SpheresPrim spheres;
	coat::dialog dlg;
	// load generator settings if exist
	spheres.ReadFromFile("data/Temp/SpheresPrim.json");
	if(dlg.ok().cancel().params(&spheres).show() == 1) {// ok pressed, buttons start from 1
		// save settings
		spheres.WriteToFile("data/Temp/SpheresPrim.json");
		// build the figure
		spheres.build();
	};
	return 0;
}