// This example generates the surface figure that consists of gear
#include <CoreAPI.h>
//@config: Debug
class GearPrim:public BaseClass {
public:
	GearPrim() {
		Radius = 50;
		Depth = 0.1;
		Sharpness = 0.5;
		Height = 100;
		Order = 16;
	}
	float Radius;
	float Depth;
	float Sharpness;
	float Height;
	int  Order;
	
	// this is class registration, look dialogs example
	SERIALIZE() {
		FSLIDER(Radius, "%Radius", 10, 100, 50, false);
		FSLIDER(Depth, "%Depth", 0.1, 1, 0.1, false);
		FSLIDER(Sharpness, "%Sharpness", 0.1, 1, 0.5, false);
		FSLIDER(Height, "%Height", 20, 200.0, 100, false);
		SLIDER(Order, "%Order", 8, 32, 16, false);
	}
	void build() {
		auto voxId = coat::Scene::sculptRoot().childCount();
		auto current = coat::Scene::sculptRoot().addChild("Gear"+coat::str::ToString(voxId));
		auto volume = current.Volume();
		volume.toSurface();
		coat::gear gear;
		gear.height(Height)
			.radiusTop(Radius)
			.radiusBottom(Radius)
			.Obj<coat::gear>()
			.depth(Depth)
			.sharpness(Sharpness)
			.order(Order)
			.details(0.2)
			.add(volume);
	}
};


EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	GearPrim gearPrim;
	coat::dialog dlg;
	// load settings if exist
	gearPrim.ReadFromFile("data/Temp/gear.json");
	if(dlg.ok().cancel().params(&gearPrim).show() == 1) {// ok pressed, buttons start from 1
		// save settings
		gearPrim.WriteToFile("data/Temp/gear.json");
		// build the figure
		gearPrim.build();
	};
	return 0;
}