// This example generates the detail for the further 3D printing using the surface mode. The CSG principles demonstrated.
#include <CoreAPI.h>
//@config: Debug
using namespace coat;

// The general problem of surface mode - boolean operations are less stable that in voxels.
// So you need to avoid booleans of objects with identical planes intersections.
EXPORT
int main() {
	// create new volume, don't need to set density as in voxels
	auto current = Scene::sculptRoot().addChild("Detail");
	// get the volume object to refer later
	auto volume = current.Volume();
	// turn to surface mode
	volume.toSurface();
	// set the details level for the more consistent polygons density
	prim::push_details(3);
	// add the sphere, diameter 16, dense (30 divisions)
	sphere().diameter(16).details(30).add(volume);
	// the cylinder that will be use to clip the top and bottom of the figure
	cylinder clip;
	clip.height(10).diameter(20);
	//move down 9mm and subtract. We move 9mm (not 10) to avoid planes exact intersection,
	//because exact intersection is problematic for the surface mode. 
	clip.y(-9).subtract(volume);
	//move up 9mm (back) and additionally 7 mm up and subtract
	clip.y(9 + 7).subtract(volume);
	// add the base of the figure. pay attention, we create temporary object using the cylinder() and operate,
	// this is a bit different from the clip object that we used twice
	cylinder().height(1.25).diameterBottom(19.0).diameterTop(18.5).add(volume);
	// make hole at the top
	cylinder().height(8).diameter(6).y(4).subtract(volume);
	// make hole through all the object
	cylinder().height(8).diameter(3).y(-2).subtract(volume);
	// no need to relax at the end because the surface is clean
	return 0;
}