// This example generates the surface figure rolling pin that consists of cylinders
#include <CoreAPI.h>
//@config: Debug
EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	// add new volume
	auto voxId = coat::Scene::sculptRoot().childCount();
	auto current = coat::Scene::sculptRoot().addChild("Rolling pin"+coat::str::ToString(voxId));
	auto volume = current.Volume();
	// turn to surface
	volume.toSurface();
	float height = 100;
	float radius = 12;
	float fillet = 0.5;
	float rotate = 90;
	float fscale = 4;
	coat::cylinder cylinder1(height,radius,radius,fillet);
	coat::cylinder cylinder2(height,radius/2,radius/2,fillet);
	//to scale
	cylinder1.scale(fscale);
	cylinder2.scale(fscale);
	// go to translate for all prims
	coat::prim::push_translate(coat::vec3(fscale*height/2,0,0));
	// get transform matrix of the first cylinder
	coat::mat4 matrix = cylinder1.transform();
	// rotate around axis z
	matrix *= coat::mat4::RotationZ(rotate);
	// add first figure
	cylinder1.transform(matrix).add(volume);
	// get transform matrix of the second cylinder
	matrix = cylinder2.transform();
	// rotate around axis z
	matrix *= coat::mat4::RotationZ(rotate);
	// add second cylinder in the volume
	cylinder2.transform(matrix).translate(coat::vec3(-fscale*height/3,0,0)).add(volume);
	cylinder2.transform(matrix).translate(coat::vec3(fscale*height/3,0,0)).add(volume);
	coat::prim::reset_transform();
	return 0;
}