// The metaballs example
#include <CoreAPI.h>
//@config: Release
// this is the class with parameters. It is used in UI and for the generating as well. Look the dialogs example.
class Metaballs:public BaseClass {
public:
	Metaballs() {
		numSpheres = 70;
		FigureRadius = 80;
		FigureRadiusVariation = 0.1;
		SpheresRadius = 6;
		SpheresRadiusVariation = 0.5;
	}
	int numSpheres;
	float FigureRadius;
	float FigureRadiusVariation;
	float SpheresRadius;
	float SpheresRadiusVariation;

	// this is class registration, look dialogs example
	SERIALIZE() {
		SLIDER(numSpheres, "numSpheres", 1, 1000);
		FSLIDER(FigureRadius, "FigureRadius", 1, 100, 1, false);
		FSLIDER(FigureRadiusVariation, "FigureRadiusVariation", 0, 1, 100, false);
		FSLIDER(SpheresRadius, "SpheresRadius", 1, 100, 1, false);
		FSLIDER(SpheresRadiusVariation, "SpheresRadiusVariation", 0, 1, 100, false);
	}
	// generate random value with variation
	float random(float value, float variation) {
		return value * (1.0f + variation * rand() / 32768.0f);
	}
	// generate the random spheres
	void generate() {
		// add new volume
		auto current = coat::Scene::sculptRoot().addChild("Methaballs:" + coat::str::ToString(numSpheres));
		auto volume = current.Volume();

		// turn to voxels
		volume.toVoxels();
		coat::list<coat::vec3> centers;
		coat::list<float> radius;
		for (int i = 0; i < numSpheres; i++) {
			radius.Add(random(SpheresRadius, SpheresRadiusVariation));
			centers.Add(coat::vec3::RandNormal() * random(FigureRadius, FigureRadiusVariation));
		}
		// This function generates the object based on the volumetric formula f(vector) = 0.5
		// It requires also the set of start points.
		volume.makeVoxelFigure(
			[&](coat::vec3 pos) {
				float value = 0;
				for (int i = 0; i < centers.Count(); i++) {
					// ball radius
					float r = radius[i];
					// the square of the distance
					float d = pos.distanceSq(centers[i]) - radius[i];
					// the denominator for the formula below
					float den = d + 16.0f * r - r * r;
					if (den < 0.01f)den = 0.01f;
					// the summ
					value += 32.0f * r / den;
				}
				// the cut threshold
				value -= 2.5f;
				return value;
			}, centers);
	}
};

EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	// create the generator object
	Metaballs sg;
	coat::dialog dlg;
	// load generator settings if exist
	sg.ReadFromFile("data/Temp/Balls.json");
	if(dlg.ok().cancel().params(&sg).show() == 1) {// ok pressed, buttons start from 1
		// save settings
		sg.WriteToFile("data/Temp/Balls.json");
		// generate the figure
		sg.generate();
	};
	return 0;
}